#!/bin/python3
import os


def retrieve_url(url, *,
                 check_certificates=True, timeout=60, error_status=True):
    from urllib.request import Request, urlopen
    request = Request(url, unverifiable=True)
    request.headers['Accept-encoding'] = 'identity'
    if check_certificates:
        ssl_context = None
    else:
        import ssl
        ssl_context = ssl.create_default_context()
        ssl_context.check_hostname = False
        ssl_context.verify_mode = ssl.CERT_NONE
    with urlopen(request, timeout=timeout, context=ssl_context) as response:
        print('Fetching %s' % request.get_full_url())
        content_length = response.headers['Content-Length']
        if content_length is not None:
            content_length = int(content_length)
        data = response.read()
        if content_length is not None and len(data) != content_length:
            from urllib.request import URLError
            raise URLError(
                f'Got {len(data)} bytes when {content_length} were expected')
    print('Fetched %s' % request.get_full_url())


if 1:
    import certifi
    os.environ["SSL_CERT_FILE"] = certifi.where()
    url = "https://files.wwpdb.org/pub/pdb/refdata/chem_comp/P/NAP/NAP.cif"
    print("Try without checking certificates")
    retrieve_url(url, check_certificates=False)
    print("Try with checking certificates")
    retrieve_url(url)
