import multiprocessing as mp
from time import sleep


def do_sim():
    from simtk.openmm import app
    from simtk import openmm
    from simtk import unit
    platform = openmm.Platform.getPlatformByName('OpenCL')
    pdb = app.PDBFile('input.pdb')
    forcefield = app.ForceField('amber99sb.xml', 'amber99_obc.xml')
    system = forcefield.createSystem(pdb.topology, nonbondedMethod=app.CutoffNonPeriodic, nonbondedCutoff=1.0*unit.nanometer, constraints=app.HBonds)
    integrator = openmm.LangevinIntegrator(300*unit.kelvin, 1/unit.picosecond, 0.002*unit.picoseconds)
    context = openmm.Context(system, integrator, platform)
    context.setPositions(pdb.positions)
    context.setVelocitiesToTemperature(300*unit.kelvin)
    context.getIntegrator().step(100)

#do_sim()
#print('done')



def sim_thread(queue):
    do_sim()
    queue.put('Finished')

global error
error = False

def error_cb(e):
    global error
    print(e)
    error = True

manager = mp.Manager()
out_q = manager.Queue()

error = None

p = mp.Pool(processes = 1)
p.apply_async(sim_thread, args = (out_q, ), error_callback = error_cb)
msg_count = 0
while msg_count < 1:
    if error:
        break
    if not out_q.empty():
        msg = out_q.get()
        if msg == 'Fail!':
            error = msg
            break
        print(msg)
        msg_count += 1
    sleep(1e-1)
