# replace PseuodbondGroup __init__ to allow tracking via weak refs

_weak_refs = []
def replacement__init__(self, *args, **kw):
	self._orig__init__(*args, **kw)
	from weakref import ref
	_weak_refs.append(ref(self))

from chimerax.atomic import PseudobondGroup
PseudobondGroup._orig__init__ = PseudobondGroup.__init__
PseudobondGroup.__init__ = replacement__init__

from chimerax.core.commands import run
run(session, "open 7azs")
run(session, "close")
import gc
gc.collect()
import sys
alive = [x for x in _weak_refs if x() is not None]
print("before wait", len(alive), "live refs:", [(x(), "%d refs" % sys.getrefcount(x())) for x in alive])
if len(alive) > 0:
	print("Referrers to first entry:")
	print(gc.get_referrers(alive[0]()))
run(session, "wait 1")
alive = [x for x in _weak_refs if x() is not None]
print("after wait", len(alive), "live refs:", [x() for x in alive])


