#!/bin/env python3
# vi:set expandtab shiftwidth=4:

import gc
import os
import subprocess
import sys
from chimerax.mmcif import open_mmcif

CIF_PARENT = "/databases/mol/mmCIF"
current_memory_usage = None


def get_memory_use():
    gc.collect()
    output = subprocess.check_output(['/usr/bin/pmap', str(os.getpid())])
    usage = output.split()[-1].decode()
    return usage


def print_delta_memory(tag, first, second):
    delta = int(second[:-1]) - int(first[:-1])
    print(f"{tag}: {delta}{first[-1]}")


def print_increased_memory():
    global current_memory_usage
    if current_memory_usage is None:
        current_memory_usage = start_usage
    usage = get_memory_use()
    print_delta_memory("Increased memory use", current_memory_usage, usage)
    current_memory_usage = usage


def read_files():
    global start_usage
    start_usage = get_memory_use()
    print(f"Starting memory use:  {start_usage}")
    for dirpath, dirnames, filenames in os.walk(CIF_PARENT):
        # print(dirpath, flush=True)
        if not filenames:
            # print('no filenames. dirname=', dirnames)
            continue
        for fn in filenames:
            full_path = os.path.join(dirpath, fn)
            print('  --', fn, flush=True)
            models = open_mmcif(session, full_path, auto_style=False, log_info=False, slider=False)
            del models
            gc.collect()
            print_increased_memory()


if __name__.startswith("ChimeraX_sandbox_"):
    read_files()
