# See if garbage collector objects and references matches reference counts

import gc
gc.collect()
gc.disable()

objects = gc.get_objects()
print (f'Garbage collector sees {len(objects)} objects')

from sys import getrefcount
for i,o in enumerate(objects):
    r = gc.get_referrers(o)
    nr = len(r)
    rc = getrefcount(o)
    if rc < nr+1:
        print(f'object {i}, {nr} referrers, ref count {rc}, type {type(o)}, object {o}')
        break

gc.enable()
